import { Action } from '../actions';
import { TournamentEntryModel } from '../models';

export const UPDATE_TOURNAMENT_ENTRIES = 'UPDATE_TOURNAMENT_ENTRIES';
export const DELETE_TOURNAMENT_ENTRIES = 'DELETE_TOURNAMENT_ENTRIES';

export interface UpdateTournamentEntriesAction extends
  Action<typeof UPDATE_TOURNAMENT_ENTRIES, TournamentEntryModel[]> {}

export interface DeleteTournamentEntriesAction extends
  Action<typeof DELETE_TOURNAMENT_ENTRIES, TournamentEntryModel[]> {}

export function createUpdateTournamentEntriesAction(tournamentEntries: TournamentEntryModel[]):
  UpdateTournamentEntriesAction {
  return {
    type: UPDATE_TOURNAMENT_ENTRIES,
    payload: tournamentEntries
  };
}

export function createDeleteTournamentEntriesAction(tournamentEntries: TournamentEntryModel[]):
  DeleteTournamentEntriesAction {
  return {
    type: DELETE_TOURNAMENT_ENTRIES,
    payload: tournamentEntries
  };
}

export type TournamentEntryActions = UpdateTournamentEntriesAction |
  DeleteTournamentEntriesAction;
