import { Action } from '../actions';
import { UserModel } from '../models';

export const UPDATE_USERS = 'UPDATE_USERS';
export const AUTH_USER = 'AUTH_USER';
export const LOGOUT_USER = 'LOGOUT_USER';

export interface UpdateUsersAction extends Action<typeof UPDATE_USERS, UserModel[]> {}
export interface AuthUserAction extends Action<typeof AUTH_USER, UserModel> {}
export interface LogoutAction extends Action<typeof LOGOUT_USER, undefined> {}

export function createUpdateUsersAction(users: UserModel[]): UpdateUsersAction {
  return {
    type: UPDATE_USERS,
    payload: users
  };
}

export function createAuthUserAction(user: UserModel): AuthUserAction {
  return {
    type: AUTH_USER,
    payload: user
  };
}

export function createLogoutAction(): LogoutAction {
  return {
    type: LOGOUT_USER,
    payload: undefined
  };
}

export type All = UpdateUsersAction | AuthUserAction | LogoutAction;
