import * as fetch from 'isomorphic-fetch';
import * as actions from '../actions';
import { config } from '../config';
import {
  APIHandler,
  APIRequest,
  authUser
} from './index';

// TODO thenable this?
// I haven't figured out a good way to extend Promise/Thenable.
export class APIAction {
  public handler: APIHandler;
  public request: APIRequest;
  public promise: Promise<any>;
  public resolve: Function;
  public reject: Function;

  public constructor(options: any = {}) {
    this.handler = options.handler;
    this.request = options.request;
    this.promise = new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    });
  }

  public fetch() {
    this.request.options.headers = Object.assign({
      'Client-ID': config.apiClientId,
      Authorization: config.authToken ? 'Bearer ' + config.authToken : ''
    }, this.request.options.headers);

    return fetch(this.request.url, this.request.options as RequestInit)
      .then((response: any) => {
        switch (response.status) {
          case 401: return this.handler.dispatch(authUser());
          case 204: return { status: 204 };
          default: return response.json();
        }
      })
      .then((json: any) => {
        // TODO instead of dispatching via action.promise.then in async
        // creators, resolve w/ the actual action and set the meta on it.
        this.handler.dispatch({
          type: actions.API_FETCH_DONE,
          payload: json,
          meta: {
            fetch: {
              url: this.request.url,
              done: true
            }
          }
        });

        // TODO
        // We resolve APIAction.promise with the raw json and the returned
        // promise (chaining on an async action creator) with just data, as
        // that is what they currently use for the most part.
        switch (json.status) {
          case 204:
          case 302:
          case 200:
            this.resolve(json);
            return Promise.resolve(json.data);
          default:
            return Promise.reject(json);
        }
      }).catch((e) => {
        this.reject(e);
        return Promise.reject(e);
      });
  }
}
