import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { ArticleModel } from '../models/article';

export function createOrUpdateArticle(article: ArticleModel) {
  return (article.id && article.id !== '')
    ? updateArticle(article)
    : createArticle(article);
}

export function createArticle(article: ArticleModel) {
  const formData = createFormData(article);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateArticlesAction([json.data]));
    });
    return action;
  };
}

export function updateArticle(article: ArticleModel) {
  const formData = createFormData(article);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles/${article.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateArticlesAction([json.data]));
    });
    return action;
  };
}

export function publishArticle(article: ArticleModel) {
  const formData = createFormData({
    id: article.id,
    state: 'final'
  });

  const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles/${article.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateArticlesAction([json.data]));
    });
    return action;
  };
}

export function getArticles(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateArticlesAction(json.data));
    });
    return action;
  };
}

export function getArticle(articleId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles/${articleId}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateArticlesAction([json.data]));
    });
    return action;
  };
}

export function deleteArticle(articleId: string) {
   const request: APIRequest = {
    url: `${config.apiUrl}/v1/articles/${articleId}`,
    options: {
      method: 'DELETE'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createDeleteArticleAction(json.data));
    });
    return action;
  };
}
