import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { EventModel } from '../models/event';

export function createOrUpdateEvent(event: EventModel) {
  return (event.id && event.id !== '')
    ? updateEvent(event)
    : createEvent(event);
}

export function createEvent(event: EventModel) {
  const formData = createFormData(event);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/events`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateEventsAction([json.data]));
    });
    return action;
  };
}

export function updateEvent(event: EventModel) {
  const formData = createFormData(event);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/events/${event.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateEventsAction([json.data]));
    });
    return action;
  };
}

export function getEvents(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/events`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateEventsAction(json.data));
    });
    return action;
  };
}

export function getEvent(eventId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/events/${eventId}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateEventsAction([json.data]));
    }).catch((e) => {
      dispatch(Actions.createErrorAction(e));
    });
    return action;
  };
}

export function deleteEvent(eventId: string) {
   const request: APIRequest = {
    url: `${config.apiUrl}/v1/events/${eventId}`,
    options: {
      method: 'DELETE'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createDeleteEventAction(json.data));
    });
    return action;
  };
}
