import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { GameModel } from '../models/game';

export function createOrUpdateGame(game: GameModel) {
  return (game.id && game.id !== '')
    ? updateGame(game)
    : createGame(game);
}

export function createGame(game: GameModel) {
  const formData = createFormData(game);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/games`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateGamesAction([json.data]));
    });
    return action;
  };
}

export function updateGame(game: GameModel) {
  const formData = createFormData(game);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/games/${game.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateGamesAction([json.data]));
    });
    return action;
  };
}

export function getGames(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/games`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateGamesAction(json.data));
    });
    return action;
  };
}

export function getGame(gameId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/games/${gameId}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateGamesAction([json.data]));
    }).catch((e) => {
      dispatch(Actions.createErrorAction(e));
    });
    return action;
  };
}
