import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';

export function uploadImage(file: any) {
  const formData = createFormData({
    image: file
  });
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/images`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    return action;
  };
}
