import * as Actions from '../actions';
import {
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { MatchModel } from '../models/match';

export function createOrUpdateMatch(match: MatchModel) {
  return (match.id && match.id !== '')
    ? updateMatch(match)
    : createMatch(match);
}

export function createMatch(match: MatchModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/matches`,
    options: {
      method: 'POST'
    },
    object: match
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateMatchesAction([json.data]));
    });
    return action;
  };
}

export function updateMatch(match: MatchModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/matches/${match.id}`,
    options: {
      method: 'PATCH'
    },
    object: match
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateMatchesAction([json.data]));
    });
    return action;
  };
}

export function getMatches(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/matches`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateMatchesAction(json.data));
    });
    return action;
  };
}
