import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { EventModel } from '../models/event';

export function getSchedule(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/schedule`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateScheduleAction(json.data));
    });
    return action;
  };
}
