import * as Actions from '../actions';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { SeasonModel } from '../models/season';

export function createOrUpdateSeason(season: SeasonModel) {
  return (season.id && season.id !== '')
    ? updateSeason(season)
    : createSeason(season);
}

export function createSeason(season: SeasonModel) {
  const formData = createFormData(season);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/seasons`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeasonsAction([json.data]));
    });
    return action;
  };
}

export function updateSeason(season: SeasonModel) {
  const formData = createFormData(season);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/seasons/${season.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeasonsAction([json.data]));
    });
    return action;
  };
}

export function getSeasons(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/seasons`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeasonsAction(json.data));
    });
    return action;
  };
}

export function getSeason(seasonId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/seasons/${seasonId}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeasonsAction([json.data]));
    }).catch((e) => {
      dispatch(Actions.createErrorAction(e));
    });
    return action;
  };
}
