import * as Actions from '../actions';
import {
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { SeriesModel } from '../models/series';

export function createOrUpdateSeries(series: SeriesModel) {
  return (series.id && series.id !== '')
    ? updateSeries(series)
    : createSeries(series);
}

export function createSeries(series: SeriesModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/series`,
    options: {
      method: 'POST'
    },
    object: series
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeriesAction([json.data]));
    });
    return action;
  };
}

export function updateSeries(series: SeriesModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/series/${series.id}`,
    options: {
      method: 'PATCH'
    },
    object: series
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeriesAction([json.data]));
    });
    return action;
  };
}

export function getSeries(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/series`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateSeriesAction(json.data));
    });
    return action;
  };
}
