import * as TeamActions from '../actions/team';
import {
  createFormData,
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { TeamModel } from '../models/team';

export function createOrUpdateTeam(team: TeamModel) {
  return (team.id && team.id !== '')
    ? updateTeam(team)
    : createTeam(team);
}

export function updateTeam(team: TeamModel) {
  const formData = createFormData(team);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/teams/${team.id}`,
    options: {
      headers: {},
      method: 'PATCH',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamActions.createUpdateTeamsAction([json.data]));
    });
    return action;
  };
}

export function createTeam(team: TeamModel) {
  const formData = createFormData(team);
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/teams`,
    options: {
      headers: {},
      method: 'POST',
      body: formData
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamActions.createUpdateTeamsAction([json.data]));
    });
    return action;
  };
}

export function getTeam(id: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/teams/${id}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamActions.createUpdateTeamsAction([json.data]));
    });
    return action;
  };
}

export function getTeams(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/teams`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamActions.createUpdateTeamsAction(json.data));
    });
    return action;
  };
}

export function deleteTeamUser(teamId: string, userId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/teams/${teamId}/users/${userId}`,
    options: {
      method: 'DELETE'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamActions.createUpdateTeamsAction([json.data]));
    });
    return action;
  };
}
