import { createUpdateTeamsAction } from '../actions/team';
import * as TeamInvitationActions from '../actions/teamInvitation';
import {
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { TeamInvitationModel } from '../models/teamInvitation';

export function acceptTeamInvitation(token: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/team_invitations/${token}/accept`,
    options: {
      method: 'PATCH'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      // accept returns the updated team
      dispatch(createUpdateTeamsAction([json.data]));
    });
    return action;
  };
}

export function createTeamInvitation(teamInvitation: TeamInvitationModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/team_invitations`,
    options: {
      method: 'POST'
    },
    object: teamInvitation
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamInvitationActions.createUpdateTeamInvitationsAction([json.data]));
    });
    return action;
  };
}

export function deleteTeamInvitation(id: Number) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/team_invitations/${id}`,
    options: {
      method: 'DELETE'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TeamInvitationActions.createDeleteTeamInvitationsAction([json.data]));
    });
    return action;
  };
}
