import * as Actions from '../actions';
import {
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { TournamentModel } from '../models/tournament';

export function createOrUpdateTournament(tournament: TournamentModel) {
  return (tournament.id && tournament.id !== '')
    ? updateTournament(tournament)
    : createTournament(tournament);
}

export function createTournament(tournament: TournamentModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournaments`,
    options: {
      method: 'POST'
    },
    object: tournament
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateTournamentsAction([json.data]));
    });
    return action;
  };
}

export function updateTournament(tournament: TournamentModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournaments/${tournament.id}`,
    options: {
      method: 'PATCH'
    },
    object: tournament
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateTournamentsAction([json.data]));
    });
    return action;
  };
}

export function getTournaments(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournaments`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateTournamentsAction(json.data));
    });
    return action;
  };
}

export function getTournament(tournamentId: string) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournaments/${tournamentId}`,
    options: {
      method: 'GET'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(Actions.createUpdateTournamentsAction([json.data]));
    }).catch((e) => {
      dispatch(Actions.createErrorAction(e));
    });
    return action;
  };
}
