import * as TournamentEntryActions from '../actions/tournamentEntry';
import {
  APIHandler,
  APIRequest,
  APIActionSet,
  APIParams,
  APIAction
} from '../api';
import { config } from '../config';
import { TournamentEntryModel } from '../models/tournamentEntry';

export function deleteTournamentEntry(tournamentEntry: TournamentEntryModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournament_entries/${tournamentEntry.id}`,
    options: {
      method: 'DELETE'
    }
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TournamentEntryActions.createDeleteTournamentEntriesAction([json.data]));
    });
    return action;
  };
}

export function createOrUpdateTournamentEntry(tournamentEntry: TournamentEntryModel) {
  return (tournamentEntry.id && tournamentEntry.id !== '')
    ? updateTournamentEntry(tournamentEntry)
    : createTournamentEntry(tournamentEntry);
}

export function updateTournamentEntry(tournamentEntry: TournamentEntryModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournament_entries/${tournamentEntry.id}`,
    options: {
      method: 'PATCH'
    },
    object: tournamentEntry
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction([json.data]));
    });
    return action;
  };
}

export function createTournamentEntry(tournamentEntry: TournamentEntryModel) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournament_entries`,
    options: {
      method: 'POST'
    },
    object: tournamentEntry
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction([json.data]));
    });
    return action;
  };
}

export function getTournamentEntries(params: APIParams = {}) {
  const request: APIRequest = {
    url: `${config.apiUrl}/v1/tournament_entries`,
    options: {
      method: 'GET'
    },
    params
  };

  const actions: APIActionSet = {};

  return (dispatch: any) => {
    const api = new APIHandler(dispatch);
    const action = api.call(request, actions);
    action.promise.then((json) => {
      dispatch(TournamentEntryActions.createUpdateTournamentEntriesAction(json.data));
    });
    return action;
  };
}
