import { Action, combineReducers, Middleware, Dispatch } from 'redux';
import { APIAction } from './api';

export type ThunkAction<R, S, E> = (dispatch: Dispatch<S>, getState: () => S,
                                    extraArgument: E) => R;

declare module 'redux' {
  export interface Dispatch<S> {
    <R, E>(asyncAction: ThunkAction<R, S, E>): R;
  }
}

export const middleware = [(store: any) => (next: Function) => (action: any) => {
  if (typeof action === 'function') {
    const apiAction = action(store.dispatch, store.getState);

    if (apiAction instanceof APIAction) {
      const requests = store.getState().tourney.requests;
      if (requests[apiAction.request.url] && requests[apiAction.request.url] > 1) {
        return;
      }

      const fetchAction = {
        type: 'API_FETCH',
        meta: {
          fetch: {
            url: apiAction.request.url
          }
        }
      };
      next(fetchAction);
      return apiAction.fetch();
    }

    return apiAction;
  }

  return next(action);
}];
