import { normalize } from 'normalizr';

import { Action } from '../actions';
import * as TeamInvitation from '../actions/teamInvitation';
import { TeamInvitationModel } from '../models/teamInvitation';
import { TeamInvitationSchema } from '../schemas';

export type NormalizedTeamInvitations = {
  [id: string]: TeamInvitationModel
};

function normalizeTeamInvitations(entries: TeamInvitationModel[]) {
  const normalized = normalize(entries, [TeamInvitationSchema]);
  return normalized.entities.team_invitations;
}

export function teamInvitations(state: Object = {}, action: TeamInvitation.TeamInvitationActions): Object {
  switch (action.type) {
    case TeamInvitation.UPDATE_TEAM_INVITATIONS:
      return Object.assign({}, state, normalizeTeamInvitations(action.payload));
    default:
      return state;
  }
}
