import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import * as reducer from '../../lib/reducer';

import { middleware } from '../../lib/middleware';
const mockStore = configureStore(middleware);
const store = mockStore({ tourney: reducer.DefaultState });

import { config } from '../../lib/config';
config.apiUrl = 'http://example.com';

import {
  APIHandler,
  createFormData
} from '../../lib/api';

describe('APIAction', () => {
  it('should handle 204 responses', async () => {
    const api = new APIHandler(store.dispatch);
    const request: APIRequest = { url: config.apiUrl + '/v1/testing' };
    nock('http://example.com/v1').get('/testing').
      reply(204, { status: 204 });
    const action = api.call(request, {});
    return await action.fetch();
  });
});

describe('createFormData', () => {
  // Note: FormData will stringify values, including undefined and null.
  // We clearly don't want to send that.
  it('should reject undefined and null values', async () => {
    const formData = createFormData({
      undefinedValue: undefined,
      nullValue: null
    });
    expect(formData.get('undefinedValue')).toEqual(null);
    expect(formData.get('nullValue')).toEqual(null);
  });

  it('should resolve circular references', async () => {
    let circle = {};
    circle.circle = circle;
    const formData = createFormData(circle);
    expect(formData.get('circle')).toEqual(null);
  });
});
