import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import { middleware } from '../../lib/middleware';
const mockStore = configureStore(middleware);

import { config } from '../../lib/config';
config.apiUrl = 'http://example.com';

import * as reducer from '../../lib/reducer';
import * as actions from '../../lib/actions/game';
import * as api from '../../lib/api/game';

describe('api/game', () => {
  describe('createGame', () => {
    it('should create UPDATE_GAMES when successful', async () => {
      const game = { name: 'LoL of Legends' };
      nock('http://example.com/v1').
        post('/games').
        reply(200, { status: 200, data: game });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.createGame(game));
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_GAMES,
        payload: [game]
      });
    });
  });

  describe('getGames', () => {
    it('should create UPDATE_GAMES when successful', async () => {
      const game = { name: 'League of for Babies' };
      nock('http://example.com/v1').
        get('/games').
        reply(200, { status: 200, data: [game] });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.getGames());
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_GAMES,
        payload: [game]
      });
    });
  });

  describe('getGame', () => {
    it('should create UPDATE_GAMES when successful', async () => {
      const game = { id: 'test-test-test-test',
        name: 'DotA Zwei' };
      nock('http://example.com/v1').
        get(`/games/${game.id}`).
        reply(200, { status: 200, data: game });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.getGame(game.id));
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_GAMES,
        payload: [game]
      });
    });
  });

  describe('updateGame', () => {
    it('should accept object w/ circular references', async () => {
      let game = { id: 'test-test-test-test',
        name: 'DotA Zwei' };
      game['tournaments'] = [{
        name: 'Das Internationale Siebzehn',
        game: game
      }];
      expect(api.updateGame(game)).not.toThrow();
    });
  });
});
