import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import { middleware } from '../../lib/middleware';
const mockStore = configureStore(middleware);

import { config } from '../../lib/config';
config.apiUrl = 'http://example.com';

import * as reducer from '../../lib/reducer';
import * as actions from '../../lib/actions/team';
import * as api from '../../lib/api/team';

describe('api/team', () => {
  describe('createTeam', () => {
    it('should create UpdateTeamsAction when successful', async () => {
      const team = { name: 'S A D B O Y S' };
      nock('http://example.com/v1').
        post('/teams').
        reply(200, { status: 200, data: team });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.createTeam(team));
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_TEAMS,
        payload: [team]
      });
    });
  });

  describe('getTeams', () => {
    it('should create UpdateTeamsAction when successful', async () => {
      const team = { name: 'S A D B O Y S' };
      nock('http://example.com/v1').
        get('/teams').
        reply(200, { status: 200, data: [team] });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.getTeams());
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_TEAMS,
        payload: [team]
      });
    });
  });

  describe('updateTeam', () => {
    it('should accept object w/ circular references', async () => {
      const team = { name: 'RIP EG' };
      team['users'] = [{
        name: 'Farteezy',
        teams: [team]
      }]
      expect(api.updateTeam(team)).not.toThrow();
    });
  });
});
