import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import { middleware } from '../../lib/middleware';
const mockStore = configureStore(middleware);

import { config } from '../../lib/config';
config.apiUrl = 'http://example.com';

import * as reducer from '../../lib/reducer';
import * as actions from '../../lib/actions/teamInvitation';
import * as api from '../../lib/api/teamInvitation';

describe('api/teamInvitation', () => {
  describe('createTeamInvitation', () => {
    it('should accept object w/ circular references', async () => {
      const teamInvitation = { team_id: 'test-test-test-test', email: 'test@example.com' };
      teamInvitation['team'] = {
        name: 'The Alliance Is Back',
        team_invitations: [teamInvitation]
      }
      expect(api.createTeamInvitation(teamInvitation)).not.toThrow();
    });
  });
});
