import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import { middleware } from '../../lib/middleware';
const mockStore = configureStore(middleware);

import { config } from '../../lib/config';
config.apiUrl = 'http://example.com';

import * as reducer from '../../lib/reducer';
import * as actions from '../../lib/actions/tournament';
import * as api from '../../lib/api/tournament';

describe('api/tournament', () => {
  describe('createTournament', () => {
    it('should create UPDATE_TOURNAMENTS when successful', async () => {
      const tournament = { name: 'The International 19' };
      nock('http://example.com/v1').
        post('/tournaments').
        reply(200, { status: 200, data: tournament });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.createTournament(tournament));
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_TOURNAMENTS,
        payload: [tournament]
      });
    });
  });

  describe('getTournaments', () => {
    it('should create UPDATE_TOURNAMENTS when successful', async () => {
      const tournament = { name: 'The International 19' };
      nock('http://example.com/v1').
        get('/tournaments').
        reply(200, { status: 200, data: [tournament] });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.getTournaments());
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_TOURNAMENTS,
        payload: [tournament]
      });
    });
  });

  describe('getTournament', () => {
    it('should create UPDATE_TOURNAMENTS when successful', async () => {
      const tournament = { id: 'test-test-test-test',
        name: 'The International 19' };
      nock('http://example.com/v1').
        get(`/tournaments/${tournament.id}`).
        reply(200, { status: 200, data: tournament });
      const store = mockStore({ tourney: reducer.DefaultState });
      const response = await store.dispatch(api.getTournament(tournament.id));
      expect(store.getActions()).toContainEqual({
        type: actions.UPDATE_TOURNAMENTS,
        payload: [tournament]
      });
    });
  });

  describe('updateTournament', () => {
    it('should accept object w/ circular references', async () => {
      let tournament = {
        id: 'test-test-test-test',
        name: 'The International 19' };
      tournament['tournament_entries'] = [{
        id: 'test-test-test-test',
        tournament: tournament
      }];
      expect(api.updateTournament(tournament)).not.toThrow();
    });
  });
});
