import configureStore from 'redux-mock-store';
import * as nock from 'nock';

import { middleware } from '../lib/middleware';
const mockStore = configureStore(middleware);

import * as reducer from '../lib/reducer';
import { config } from '../lib/config';
config.apiUrl = 'http://example.com';
config.store = mockStore({ tourney: reducer.DefaultState });

import { normalize } from 'normalizr';
import * as schemas from '../lib/schemas';

jest.useFakeTimers();

describe('schemas/TournamentSchema', () => {
  it('should queue getTournament to receive missing entries when normalized', async () => {
    expect.assertions(2);
    const tournament = {
      id: 1,
      name: 'test',
      tournament_entry_ids: [2, 3]
    };
    nock('http://example.com/v1').
      persist(). // Something doubles the request somewhere, TODO for another time
      get('/tournaments/1').
      reply(200, { status: 200, data: tournament });
    const spy = jest.spyOn(config.store, 'dispatch');
    const normalized = normalize(tournament, schemas.TournamentSchema);
    jest.runAllTimers();
    expect(spy).toHaveBeenCalled();
    // In absence of this (see api/action.ts), we'll check if the fetch was
    // dispatched.
    // const action = await spy.mock.calls[0][0](config.store.dispatch);
    expect(config.store.getActions()).toContainEqual({
      type: 'API_FETCH',
      meta: { fetch: { url: 'http://example.com/v1/tournaments/1' } }
    });
  });
});
