// https://github.com/kulshekhar/ts-jest/issues/79 LUL

// See https://github.com/facebook/jest/issues/890 Kappa
Object.defineProperty(window.location, 'href', { writable: true });

var localStorageMock = (function() {
  var store = {};
  return {
    getItem: function(key) {
      return store[key];
    },
    setItem: function(key, value) {
      store[key] = value.toString();
    },
    removeItem: function(key) {
      delete store[key];
    },
    clear: function() {
      store = {};
    }
  };
})();
Object.defineProperty(window, 'localStorage', { value: localStorageMock });

process.on('unhandledRejection', function (e) {
  console.log('unhandled rejection: ', e);
  // TODO Consider throwing.
});
