# Tourney User Signup flow

![](signup.flowchart.svg)

#### GET /auth

##### Passport

If not given a token, /auth will return a (status 200, "status" 302) redirect response with a new Token and a redirect_url. The user will be redirected and returns with an oauth callback code (state.)

Following an oauth callback, the call to /auth will include the persisted token and the state (code) param passed through by the oauth application.

With these, passport will initiate the OAuth callback and given success, receive an OAuth info object.

With OAuth info, passport will find or create an Account using the given information.

If the account does not belong to a User, a new User will be created for it. The existing, or newly created user will be returned.

When given a valid token for a User, /auth will directly return the user the Token belongs to.

##### Edge

With /auth returning a valid user, edge will ask edb for a `Person` with the user's ID which will find or create a `Person` by `user_id` and merges it.

##### Important notes:

All Organization assignment is done via [`Person.handle_user_change`](https://git-aws.internal.justin.tv/esports/edb/blob/master/app/models/person.rb#L54) through [bin/kinesis](https://git-aws.internal.justin.tv/esports/edb/blob/master/bin/kinesis#L34)

This finds or creates an `Organization` **and** `Person` for the `User`
