#!/bin/bash
#
# Important: this does not create any resources. It works in conjunction w/
# Terraform and is meant to bump the current TD of the service.

service_name=twt
region=us-west-2

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}

version=`git rev-parse --short HEAD`

read -p "Build docker image? [Y/N]" -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  export NODE_ENV=production
  case "$1" in
    staging)
      export REACT_APP_GAME_ID=4c760cf2-ba95-4f16-8204-7673cbc2c674
      ;;
    production)
      export REACT_APP_GAME_ID=4c760cf2-ba95-4f16-8204-7673cbc2c674
      ;;
  esac
  rm -rf .asset-cache
  ensure npm run build
  ensure docker build -t ${service_name}-frontend:latest -f docker/frontend/Dockerfile .
fi

read -p "Push docker image? [Y/N]" -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    production)
      ecr_frontend=954268612818.dkr.ecr.us-west-2.amazonaws.com/twt-frontend
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-aws`
      ;;
    staging)
      ecr_frontend=157383839067.dkr.ecr.us-west-2.amazonaws.com/twt-frontend
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-dev`
      ;;
  esac

  ensure docker tag ${service_name}-frontend:latest ${ecr_frontend}:latest
  ensure docker push ${ecr_frontend}:latest
fi
