import React from 'react';
import { NavLink } from 'react-router-dom';
import PropTypes from 'prop-types';
import { FormattedMessage } from 'react-intl';

import icons from '../images/icons.svg';

function Breadcrumbs(props) {
  return (
    <ul className="c-breadcrumbs o-h5 t-text-transform--uppercase">
      <li>
        <NavLink to="/" className="c-breadcrumbs__link">
          <FormattedMessage id="nav.links.home" />
          <svg className="o-icon o-icon--x-small c-breadcrumbs__icon" width="16" height="16" role="presentation">
            <use xlinkHref={`${icons}#icon-right-arrow-line`} />
          </svg>
        </NavLink>
      </li>
      <li className="t-text-weight--normal">{props.currentPageTitle}</li>
    </ul>
  );
}

Breadcrumbs.propTypes = {
  currentPageTitle: PropTypes.string
};

export default Breadcrumbs;
