import Swiper from 'swiper';
import React, { Component } from 'react';
import icons from '../images/icons.svg';
import formatDate from './shared/formatDate';

import wat from '../images/hero/noodles.jpg';
import noodles from '../images/hero/hero_twt+nissin.png';

export default class Carousel extends Component {
  componentDidUpdate() {
    this.initCarousel();
  }

  initCarousel() {
    this.carousel = new Swiper('.c-carousel', {
      wrapperClass: 'c-carousel__wrapper',
      slideClass: 'c-carousel__item',
      nextButton: '.c-carousel__next',
      prevButton: '.c-carousel__previous',
      a11y: true,
      keyboardControl: true,
      buttonDisabledClass: 'is-disabled'
    });
  }

  render() {
    const { items } = this.props;

    return (
      <div className="c-carousel">
        <button className="c-carousel__previous o-button o-button--icon">
          <svg className="o-icon" width="16" height="16" role="presentation">
            <use xlinkHref={`${icons}#icon-left-arrow-line`} />
          </svg>
          <span className="o-visuallyhidden">Previous slide</span>
        </button>

        <button className="c-carousel__next o-button o-button--icon">
          <svg className="o-icon" width="16" height="16" role="presentation">
            <use xlinkHref={`${icons}#icon-right-arrow-line`} />
          </svg>
          <span className="o-visuallyhidden">Next slide</span>
        </button>

        <ul className="c-carousel__wrapper">
          {items.map((item) =>
            <li
              className="c-carousel__item"
              key={item.id}
            >
              <article style={{ backgroundImage: `url('${item.cover ? item.cover.original : ''}')` }}>
                <div className="c-carousel__title l-content">
                  {item.title.match(/nissin/i) ? <img src={noodles} /> : ''}
                  <h2>{item.title}</h2>
                  <h3>{formatDate(item.published_at)}</h3>
                  <svg className="o-icon" width="16" height="16" role="presentation">
                    <use xlinkHref={`${icons}#icon-down-arrow-line`} />
                  </svg>
                </div>
              </article>
            </li>
          )}
        </ul>
      </div>
    );
  }
};
