import React, { Component } from 'react';
import PropTypes from 'prop-types';

import icons from '../images/icons.svg';

class DropdownSelect extends Component {
  constructor(props) {
    super(props);

    this.state = {
      show: false
    };

    this.toggleShow = this.toggleShow.bind(this);
    this.handleClickOutside = this.handleClickOutside.bind(this);
  }

  componentDidMount() {
    window.addEventListener('click', this.handleClickOutside, false);
  }

  componentWillUnmount() {
    window.removeEventListener('click', this.handleClickOutside, false);
  }

  handleClickOutside(event) {
    if (!this.element.contains(event.target)) {
      this.setState({
        show: false
      });
    }
  }

  toggleShow() {
    this.setState({
      show: !this.state.show
    });
  }

  render() {
    return (
      <div className="c-dropdown-select" ref={(element) => { this.element = element; }}>
        <button
          className="o-toggle o-hidden@medium c-dropdown-select__button"
          onClick={this.toggleShow}
          aria-expanded={this.state.show}
        >
          <span className="o-button__label">
            {this.props.title}
          </span>
          <svg className="o-icon o-icon--small o-button__icon" width="16" height="16" role="presentation">
            <use xlinkHref={`${icons}#icon-down-arrow`} />
          </svg>
        </button>
        <div className="c-dropdown-select__list" aria-hidden={!this.state.show} onClick={this.toggleShow}>
          {this.props.children}
        </div>
      </div>
    );
  }
}

DropdownSelect.propTypes = {
  title: PropTypes.string.isRequired
};

export default DropdownSelect;
