import React from 'react';
import PropTypes from 'prop-types';

function Flag(props) {
  let flagImg;
  try {
    flagImg = require(`../images/flags/${props.country}.svg`);
  } catch (error) {
    return null
  }
  return (
    <span className={`o-flag ${props.className}`}>
      <img alt={props.country} src={flagImg} className="o-object-cover"/>
    </span>
  );
}

Flag.propTypes = {
  country: PropTypes.string.isRequired,
  className: PropTypes.string
};

export default Flag;
