import React, { Component } from 'react';
import { FormattedMessage } from 'react-intl';

import Nav from './Nav';

import icons from '../images/icons.svg';

class Footer extends Component {
  render() {
    return (
      <footer role="contentinfo" className="c-footer">
        <section className="t-background-color--black t-padding-large--top t-padding-large--bottom">
          <div className="c-footer__row-one l-content">
            <div className="c-footer__logo o-flex__primary t-color--grey">
              <a className="o-link" href="http://tekken.com">
                <svg className="o-icon o-logo--footer" width="16" height="16">
                  <title>Tekken world tour</title>
                  <use xlinkHref={`${icons}#logo-twt-wordmark`} />
                </svg>
              </a>
              <p className="o-h6 t-text-transform--uppercase t-text-weight--light t-no-margin">Details subject to change. <a href="https://www.twitch.tv/p/privacy-policy">Privacy Policy</a></p>
            </div>

            <ul className="o-list-inline o-list-reset c-footer__icons">
              <li className="o-list-inline__item t-margin--left">
                <a className="o-link" href="https://twitch.tv">
                  <svg className="o-icon o-icon--medium" width="16" height="16">
                    <title>Twitch</title>
                    <use xlinkHref={`${icons}#icon-twitch`} />
                  </svg>
                </a>
              </li>
              <li className="o-list-inline__item t-margin--left">
                <a className="o-link" href="https://www.bandainamcoent.com/">
                  <svg className="o-icon o-icon--medium" width="16" height="16">
                    <title>Bandai namco Entertainment</title>
                    <use xlinkHref={`${icons}#logo-bandia-namco`} />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </section>

        <section className="c-footer__row-two l-content">
          <div className="c-footer__copyright">
            <p className="o-h6 t-color--grey t-no-margin t-text-transform--uppercase t-text-weight--normal t-font-family--body">
              &copy; © BANDAI NAMCO ENTERTAINMENT INC. ALL RIGHTS RESERVED
              <br />
              <span className="t-text-weight--light">
                <FormattedMessage id="footer.all_rights" />
              </span>
            </p>
          </div>

          <div className="o-hidden@small-only c-footer__nav">
            <Nav linkClassName="o-toggle--alt" navListClassName="t-no-margin" />
          </div>
        </section>
      </footer>
    );
  }
}

export default Footer;
