import React, { Component } from 'react';
import PropTypes from 'prop-types';

class HomeHighlight extends Component {

  render() {
    const { num, content, image } = this.props;

    return (
      <div className="c-home-highlight">
        <div className="c-home-highlight__number">
          {num}
        </div>
        <div className="c-home-highlight__text">
          {content}
        </div>
        <img alt={content} className="c-home-highlight__img" src={image} />
      </div>
    );
  }
};

HomeHighlight.propTypes = {
  num: PropTypes.number,
  content: PropTypes.string,
  image: PropTypes.string
};

export default HomeHighlight;
