import React from 'react';
import Spinner from './Spinner';

export default ({ isLoading, noun, children }) => {
  if (isLoading) {
    return (
      <div className="t-text-align--center">
        <Spinner className="t-margin--ends" isWaiting={true} />
        <p className="o-h3 t-text-transform--uppercase" aria-live="polite">Loading {noun}</p>
      </div>
    )
  } else {
    return children
  }
};
