import React, { Component } from 'react';
import { NavLink } from 'react-router-dom';
import { FormattedMessage, injectIntl } from 'react-intl';
import PropTypes from 'prop-types';

import icons from '../images/icons.svg';

function Link(props) {
  return (<NavLink {...props} activeClassName="is-active" exact />);
}

class Nav extends Component {
  constructor(props) {
    super(props);

    this.state = {
      navIsVisible: false
    };

    this.onNavButtonClick = this.onNavButtonClick.bind(this);
  }

  onNavButtonClick() {
    this.setState({navIsVisible: !this.state.navIsVisible})
  }

  render() {
    const navLinks = [
      { title: this.props.intl.formatMessage({id: 'nav.links.home'}), href: '/' },
      { title: this.props.intl.formatMessage({id: 'nav.links.schedule'}), href: '/schedule' },
      { title: this.props.intl.formatMessage({id: 'nav.links.standings'}), href: '/standings' },
      { title: this.props.intl.formatMessage({id: 'nav.links.about'}), href: '/about' }
    ];

    return (
      <div>
        <button
          className="o-hidden@over-nav o-button o-button--icon o-button--toggle"
          aria-expanded={this.state.navIsVisible}
          onClick={this.onNavButtonClick}
        >
          <div className="o-button__on">
            <svg className="o-icon o-button__icon" width="16" height="16" role="presentation">
              <use xlinkHref={`${icons}#icon-menu`} />
            </svg>
            <span className="o-visuallyhidden">
              <FormattedMessage id="nav.open_button" />
            </span>
          </div>
          <div className="o-button__off">
            <svg className="o-icon o-button__icon" width="16" height="16" role="presentation">
              <use xlinkHref={`${icons}#icon-close`} />
            </svg>
            <span className="o-visuallyhidden">
              <FormattedMessage id="nav.close_button" />
            </span>
          </div>
        </button>
        <nav className="c-nav" id={this.props.navId} role="navigation" aria-hidden={!this.state.navIsVisible}>
          <ul className={`${this.props.navListClassName} c-nav__list`}>
            {navLinks.map((link, index) => (
              <li key={index}>
                <Link
                  onClick={this.onNavButtonClick}
                  to={link.href}
                  className={`${this.props.linkClassName} o-toggle o-toggle--nav o-h4`}
                  >
                  <span className="o-toggle__label">{link.title}</span>
                </Link>
              </li>
            ))}
            <li key="rules">
              <a href="/rules.pdf" className={`${this.props.linkClassName} o-toggle o-toggle--nav o-h4`}>
                <span className="o-toggle__label">{this.props.intl.formatMessage({id: 'nav.links.rules'})}</span>
              </a>
            </li>
            <li key="tickets" className="tickets">
              <a href="https://www.eventbrite.com/e/tekken-world-tour-finals-presented-by-nissin-cup-noodles-tickets-38368375845" className={`${this.props.linkClassName} o-toggle o-toggle--nav o-h4`}>
                <span className="o-toggle__label">Get Tickets</span>
              </a>
            </li>
          </ul>
        </nav>
      </div>
    );
  }
}

Nav.PropTypes = {
  navListClassName: PropTypes.string,
  linkClassName: PropTypes.string,
  navId: PropTypes.string
};

export default injectIntl(Nav);
