import React from 'react';
import PropTypes from 'prop-types';
import { HashLink as Link } from 'react-router-hash-link';

import Topbar from '../components/Topbar';

import formatDate from './shared/formatDate';

import icons from '../images/icons.svg';

const nbsp = "\u00a0";

const NewsHeader = ({ currentPageTitle, date, cover }) => (
  <header className="t-margin--bottom" role="banner">
    <div className="c-banner" style={{backgroundImage: `url(${cover})`}}>
      <div className="c-banner__content l-content">
        <div className="c-banner__titles">
          <time dateTime={date}>
            {date
              ? formatDate(date)
              : ''
            }
          </time>

          <h1 className="o-h0 t-no-margin t-line-height--ui">
            {currentPageTitle
              ? currentPageTitle
              : nbsp
            }
          </h1>

          <Link to="/#news" className="o-link">
            <svg className="o-icon o-icon--small" width="16" height="16" role="presentation">
              <use xlinkHref={`${icons}#icon-left-arrow-line`} />
            </svg>
            <span className="o-link__label">Back</span>
          </Link>
        </div>
      </div>
    </div>
  </header>
);

NewsHeader.propTypes = {
  currentPageTitle: PropTypes.string,
  date: PropTypes.string,
};

export default NewsHeader;
