import React from 'react';
import PropTypes from 'prop-types';
import { FormattedMessage } from 'react-intl';
import { Link } from 'react-router-dom';

import formatDate from './shared/formatDate';

const NewsItemImage = ({ cover }) => {
  if (cover.preview) {
    return(
      <img
        className="o-object-cover"
        srcSet={`${cover.original} 1439w, ${cover.preview} 272w`}
        sizes="100vw, (min-width: 65em) 33rem"
        alt=""
      />
    )
  }
  return null;
};

const NewsItem = ({ article }) => (
  <article className="c-card o-fixed-ratio t-margin--bottom">
    <Link className="o-link o-fixed-ratio__inner" to={`/news/${article.slug}`}>
      <NewsItemImage cover={article.cover} />
      <div className="o-absolute-cover t-padding o-flex o-flex--column">
        <div className="t-line-height-ui o-flex__primary t-color--text">
          <h4 className="o-h3 t-no-margin t-text-transform--uppercase t-text-weight--light t-font-family--body">
            <time dateTime={article.published_at}>{formatDate(article.published_at)}</time>
          </h4>
          <h3 className="o-h1 t-text-transform--uppercase">{ article.title } { article.marker }</h3>
        </div>
        <div>
          <div className="o-button o-h3">
            <span className="o-button__label">
              <FormattedMessage id="home.news.button" />
            </span>
          </div>
        </div>
      </div>
    </Link>
  </article>
);

NewsItem.propTypes = {
  article: PropTypes.shape({
    published_at: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
  }).isRequired
}

export default NewsItem;
