import React, { Component } from 'react';
import PropTypes from 'prop-types';

class PageContent extends Component {
  constructor(props) {
    super(props);

    this.state = {
      content: []
    };
  }

  componentDidMount() {
    this.fetchContent().then((content) => {
      this.setState(() => ({ content }));
    });
  }

  fetchContent() {
    // TODO: Replace with actual API call

    return Promise.resolve(this.props.content);
  }

  render() {
    const content = { __html: this.state.content };

    return (
      <main className="l-content t-text-weight--light t-color--grey" dangerouslySetInnerHTML={content} />
    );
  }
};

PageContent.propTypes = {
  content: PropTypes.string
};

export default PageContent;
