import React from 'react';
import PropTypes from 'prop-types';

import Topbar from '../components/Topbar';
import Breadcrumbs from '../components/Breadcrumbs';

function PageHeader(props) {
  return (
    <header className="t-margin--bottom" role="banner">
      <div className="c-banner">
        <div className="c-banner__content l-content">
          <div className="c-banner__titles">
            <h1 className="o-h0">{props.currentPageTitle}</h1>
            <Breadcrumbs currentPageTitle={props.currentPageTitle}/>
          </div>
        </div>
      </div>
    </header>
  );
}

PageHeader.propTypes = {
  currentPageTitle: PropTypes.string,
  banner: PropTypes.string
};

export default PageHeader;
