import React, { Component } from 'react';
import { NavLink } from 'react-router-dom';
import { FormattedMessage } from 'react-intl';

import Nav from './Nav';
import logo from '../images/logo.svg';
import noodles from '../images/presented_by_noodles.svg';

class Topbar extends Component {
  constructor(...args) {
    super(...args);
    this.state = {
      scrolled: false
    };
  }

  componentDidMount() {
    window.addEventListener('scroll', this.toggle.bind(this));
  }

  componentWillUnmount() {
    window.removeEventListener('scroll', this.toggle.bind(this));
  }

  toggle() {
    let { scrolled } = this.state;
    scrolled = window.scrollY > 100 ? true : false;
    this.setState({ scrolled });
  }

  render() {
    let classNames = ['l-topbar'];

    if (this.state.scrolled) {
      classNames.push('scrolled');
    }

    return (
      <div className={classNames.join(' ')}>
        <div className="o-flex">
          <div className="o-flex__primary">
            <NavLink to="/" className="o-link o-link--alt o-logo">
              <img className="logo" src={logo} />
              <img className="noodles" src={noodles} />
            </NavLink>
          </div>
          <Nav linkClassName="c-nav__link" navId="navigation" />
        </div>
      </div>
    );
  }
}

export default Topbar;
