import React, { Component } from 'react';
import { injectIntl } from 'react-intl';

import PageHeader from '../components/PageHeader';
import PageContent from '../components/PageContent';

import banner from '../images/mockup-schedule-banner.png';

class About extends Component {
  render() {
    const pageTitle = this.props.intl.formatMessage({id: 'about.header.title'});
    const content = this.props.intl.formatMessage({id: 'about.body_html'});

    return (
      <div>
        <PageHeader currentPageTitle={pageTitle} banner={banner} />
        <PageContent content={content} />
      </div>
    );
  }
}

export default injectIntl(About);
