import React, { Component } from 'react';
import { BrowserRouter as Router, Route } from 'react-router-dom';
import Typekit from 'react-typekit';

import Topbar from '../components/Topbar';
import Home from './Home';
import News from './News';
import Schedule from './Schedule';
import Standings from './Standings';
import Rules from './Rules';
import Sponsors from './Sponsors';
import About from './About';
import Footer from '../components/Footer';
import ScrollToTop from '../components/ScrollToTop';

class App extends Component {
  render() {
    return (
      <div>
        <Router>
          <div>
            <Topbar />
            <ScrollToTop/>
            <Route exact path="/" component={Home}/>
            <Route path="/news/:slug" component={News} />
            <Route path="/schedule" component={Schedule} />
            <Route path="/standings" component={Standings} />
            <Route path="/rules" component={Rules} />
            <Route path="/sponsors" component={Sponsors} />
            <Route path="/about" component={About} />

            <Footer />
          </div>
        </Router>
        <Typekit kitId="rgq6qgv" />
      </div>
    );
  }
}

export default App;
