import React, { Component } from 'react';

import { GAME_ID } from '../config';
import { getArticles } from 'tourney-sdk-react';

import Topbar from '../components/Topbar';
import HomePr from './home/HomePr';
import Carousel from '../components/Carousel';
import HomeNews from './home/HomeNews';
import HomeVideo from './home/HomeVideo';

class Home extends Component {
  constructor(...args) {
    super(...args);

    this.state = {
      heroItems: [],
      articles: []
    };
  }

  componentDidMount() {
    this.fetchArticles();
  }

  fetchArticles(limit, offset) {
    return getArticles({
      limit: 5,
      parent_type: 'Game',
      parent_id: GAME_ID,
      flags: 'featured'
    })(() => {}).fetch().then((articles) => {
      const heroItems = articles.slice(0, 5);
      this.setState({
        articles,
        heroItems
      });
    });
  }

  render() {
    return (
      <div>
        <main>
          <Carousel items={this.state.heroItems} />
          <HomeNews />
          <HomeVideo />
        </main>
      </div>
    );
  }
}

export default Home;
