import React from 'react';
import PropTypes from 'prop-types';
import { HashLink as Link } from 'react-router-hash-link';
import persistedStateToHtml from './persistedStateToHtml';

import icons from '../../images/icons.svg';

const Article = ({ article }) => (
  <div>
    <div
      className="t-padding-large--bottom"
      dangerouslySetInnerHTML={{ __html: persistedStateToHtml(article.body)}}
    />
    <Link to="/#news" className="o-link">
      <svg className="o-icon o-icon--small" width="16" height="16" role="presentation">
        <use xlinkHref={`${icons}#icon-left-arrow-line`} />
      </svg>
      <span className="o-link__label">Back</span>
    </Link>
  </div>
);

Article.propTypes = {
  article: PropTypes.shape({
    body: PropTypes.string,
  }).isRequired
};

export default Article;
