import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { injectIntl } from 'react-intl';

import { getArticle } from 'tourney-sdk-react';

import Loader from '../../components/Loader';
import NewsHeader from '../../components/NewsHeader';
import Article from './Article';

import fetch from '../shared/fetchWithChecks';

const initialArticleState = {
  article: {
    data: {},
    isLoading: true,
    hasError: false,
  },
};

class News extends Component {
  constructor(props) {
    super(props);
    this.state = initialArticleState;
  }

  fetchArticle(id) {
    return getArticle(id)(() => {}).fetch().then((article) => {
      this.setState({
        article: {
          data: article,
          isLoading: false
        }
      });
    });
  }

  componentDidMount() {
    const { slug } = this.props.match.params;
    this.setState(initialArticleState);
    this.fetchArticle(slug);
  }

  render() {
    const { isLoading, hasError } = this.state.article;
    const article = this.state.article.data;
    const coverImg = article.cover ? article.cover.original : null;

    return (
      <main>
        <article>
          <NewsHeader currentPageTitle={article.title} cover={coverImg} date={article.published_at} />
          <div
            className="l-content t-text-weight--light t-color--grey t-padding-large--top t-padding-large--bottom"
          >
            {hasError
              ? <div>
                  <h2>Sorry, something went wrong while loading this article.</h2>
                  <p>Please try again later.</p>
                </div>
              : <Loader isLoading={isLoading} noun="Article">
                  <Article article={article}/>
                </Loader>
            }
          </div>
        </article>
      </main>
    );
  }
}

News.propTypes = {
  match: PropTypes.shape({
    params: PropTypes.shape({
      slug: PropTypes.string.isRequired
    }).isRequired
  }).isRequired
};

export default injectIntl(News);
