import { stateToHTML } from 'draft-js-export-html';
import { convertFromRaw } from 'draft-js';

export default (persistedState) => {
  if(!persistedState) return '';

  let options = {
    blockRenderers: {
      'atomic:image': (block) => {
        let data = block.getData();
        if (data.get('src')) {
          return `<img class="c-news__image" src="${data.get('src')}" />`;
        }
      },
    },
  };
  return stateToHTML(
    convertFromRaw(
      JSON.parse(persistedState)
    ),
    options
  );
}
