import persistedStateToHtml from './persistedStateToHtml';

describe('persistedStateToHtml', () => {
  it('handles empty strings' , () => {
    const input = '';
    const expected = '';
    expect(persistedStateToHtml(input)).toEqual(expected);
  });

  it('handles undefined' , () => {
    const input = undefined;
    const expected = '';
    expect(persistedStateToHtml(input)).toEqual(expected);
  });

  it("converts strings containing Draft ContentState into HTML" , () => {
    const input = `{
      "entityMap": {},
      "blocks": [
        {
          "key": "1ahm2",
          "text": "Howdy !",
          "type": "unstyled",
          "depth": 0,
          "inlineStyleRanges": [],
          "entityRanges": []
        }
      ]
    }`;
    const expected = '<p>Howdy !</p>';
    expect(persistedStateToHtml(input)).toEqual(expected);
  });
});
