import React, { Component } from 'react';
import { FormattedMessage } from 'react-intl';

import coverPS4 from '../../images/tekken-7-cover-ps4.jpg';
import coverXBOX from '../../images/tekken-7-cover-xbox.jpg';
import coverPC from '../../images/tekken-7-cover-pc.jpg';

class HomeGame extends Component {
  render() {
    return (
      <section id="get-the-game">
        <h2 className="o-h3 o-bordered t-color--grey t-text-transform--uppercase">Get the Game</h2>

        <ul className="l-grid">
          <li className="l-grid__item l-width--4-of-12@medium">
            <a href="http://tk7.tekken.com/preorder-now" className="o-block t-margin--bottom">
              <img className="o-box-shadow l-width--12-of-12" src={coverPS4} alt="Tekken 7 Playstation version" />
              <div className="o-button o-button--primary l-width--12-of-12">
                <span className="o-button__label">
                  <FormattedMessage id="home.game.button" /> (<abbr title="Playstation 4 version">PS4</abbr>)
                </span>
              </div>
            </a>
          </li>

          <li className="l-grid__item l-width--4-of-12@medium">
            <a href="http://tk7.tekken.com/preorder-now" className="o-block t-margin--bottom">
              <img className="o-box-shadow l-width--12-of-12" src={coverXBOX} alt="Tekken 7 XBOX One version" />
              <div className="o-button o-button--primary l-width--12-of-12">
                <span className="o-button__label">
                  <FormattedMessage id="home.game.button" /> (<abbr title="XBOX One version">XB1</abbr>)
                </span>
              </div>
            </a>
          </li>

          <li className="l-grid__item l-width--4-of-12@medium">
            <a href="http://tk7.tekken.com/preorder-now" className="o-block t-margin--bottom">
              <img className="o-box-shadow l-width--12-of-12" src={coverPC} alt="Tekken 7 PC version" />
              <div className="o-button o-button--primary l-width--12-of-12">
                <span className="o-button__label">
                  <FormattedMessage id="home.game.button" /> (<abbr title="PC version">PC</abbr>)
                </span>
              </div>
            </a>
          </li>
        </ul>
      </section>
    );
  }
}

export default HomeGame;
