import 'whatwg-fetch'
import React, { Component } from 'react';

import { GAME_ID } from '../../config';
import { getArticles } from 'tourney-sdk-react';

import Loader from '../../components/Loader';
import Spinner from '../../components/Spinner';

import NewsItem from '../../components/NewsItem';

export default class extends Component {
  constructor(props) {
    super(props);
    this.state = {
      articles: [],
      limit: 80,
      displayCount: 4,
      offset: 0,
    };
  }

  componentDidMount() {
    const { limit, offset } = this.state;
    this.fetchArticles(limit, offset);
  }

  fetchArticles(limit, offset) {
    return getArticles({
      limit: this.state.limit,
      parent_type: 'Game',
      parent_id: GAME_ID,
      flags: 'featured'
    })(() => {}).fetch().then((articles) => {
      this.setState({
        articles
      });
    });
  }

  loadMore() {
    this.setState({ displayCount: this.state.displayCount + 4 });
  }

  render() {
    return (
      <section id="news" className="l-content t-margin--bottom o-scroll-target">
        <Loader isLoading={!this.state.articles.length} noun="News">
          <ul className="l-grid">
            {this.state.articles.slice(0 , this.state.displayCount).map((article) =>
              <li key={article.id} className="l-grid__item l-width--6-of-12@medium">
                <NewsItem article={article} />
              </li>
            )}

            {this.state.articles.length > this.state.displayCount &&
              <li className="l-grid__item l-width--12-of-12">
                <button
                  className="o-button o-button--load t-text-transform--uppercase"
                onClick={this.loadMore.bind(this)}
                >
                  <span className="o-link__label t-margin-x-small--right">Load more</span>
                  <Spinner isWaiting={false} />
                </button>
              </li>
            }
          </ul>
        </Loader>
      </section>
    );
  }
};
