import React, { Component } from 'react';
import { injectIntl } from 'react-intl';
import Rellax from 'rellax';
import { FormattedHTMLMessage } from 'react-intl';

import HomeHighlight from '../../../components/HomeHighlight';
import globe from '../../../images/infographic/globe.svg';
import evo from '../../../images/infographic/evo.svg';
import rankings from '../../../images/infographic/rankings.svg';
import trophy from '../../../images/infographic/trophy.svg';

import headerBackground_2560w from '../../../images/tekken-header_2560w.jpg';
import headerBackground_1920w from '../../../images/tekken-header_1920w.jpg';
import headerBackground_1280w from '../../../images/tekken-header_1280w.jpg';
import headerBackground_640w from '../../../images/tekken-header_640w.jpg';
import headerBackground_384w from '../../../images/tekken-header_384w.jpg';
import headerClip from '../../../images/pr-header-clip.svg';

class HomePr extends Component {
  constructor(props) {
    super(props);
    this.rellax = null;
  }

  componentDidMount() {
    this.rellax = new Rellax('.rellax');
  }

  componentWillUnmount() {
    this.rellax.destroy();
  }

  render() {
    const content1 = this.props.intl.formatMessage({id: 'home.infographic.1'});
    const content2 = this.props.intl.formatMessage({id: 'home.infographic.2'});
    const content3 = this.props.intl.formatMessage({id: 'home.infographic.3'});
    const content4 = this.props.intl.formatMessage({id: 'home.infographic.4'});
    const highlights = [
      <HomeHighlight num={1} content={content1} image={globe}/>,
      <HomeHighlight num={2} content={content2} image={rankings}/>,
      <HomeHighlight num={3} content={content3} image={evo}/>,
      <HomeHighlight num={4} content={content4} image={trophy}/>,
    ];
    const grid = highlights.map((highlight, idx) => {
      return (
        <li className="l-grid__item l-width--6-of-12 l-width--12-of-12@medium" key={idx}>
          {highlight}
        </li>
      );
    })

    return (
      <section id="pr" className="t-color--grey">
        <div className="c-parallax">
          <img
            className="o-absolute-cover o-object-cover rellax"
            srcSet={`${headerBackground_2560w} 2560w, ${headerBackground_1920w} 1920w, ${headerBackground_1280w} 1280w, ${headerBackground_640w} 640w, ${headerBackground_384w} 384w,`}
            sizes="100vw"
            alt=""
            data-rellax-speed="-4"
            data-rellax-percentage="0.5"
          />
          <img className="c-parallax__mask" src={headerClip} alt="" />
          <div className="c-carousel-container rellax" data-rellax-speed="2">
          </div>
        </div>

        <div className="l-content l-content--small">
          <FormattedHTMLMessage id="home.about.body" />
          <ul className="l-grid">
            {grid}
          </ul>
        </div>
      </section>
    );
  }
}

export default injectIntl(HomePr);
