import React from 'react';
import ReactDOM from 'react-dom';

import {
  API_URL,
  API_CLIENT_ID
} from './config';
import * as Tourney from 'tourney-sdk-react';
Tourney.config.apiUrl = API_URL;
Tourney.config.apiClientId = API_CLIENT_ID;

import { IntlProvider, addLocaleData } from 'react-intl';
import en from 'react-intl/locale-data/en';
import es from 'react-intl/locale-data/es';
import fr from 'react-intl/locale-data/fr';
import it from 'react-intl/locale-data/it';
import de from 'react-intl/locale-data/de';
import zh from 'react-intl/locale-data/zh';
import ko from 'react-intl/locale-data/ko';
import ru from 'react-intl/locale-data/ru';
import localeData from './locales/data.json';

import svg4everybody from 'svg4everybody';
import picturefill from 'picturefill'; // eslint-disable-line no-unused-vars

import './stylesheets/main.css';

import App from './containers/App';

addLocaleData([
  ...en,
  ...es,
  ...fr,
  ...it,
  ...de,
  ...ru,
  ...ko,
  ...zh
]);

// Define user's language. Different browsers have the user locale defined
// on different fields on the `navigator` object, so we make sure to account
// for these different by checking all of them
let language = (navigator.languages && navigator.languages[0]) ||
                 navigator.language ||
                 navigator.userLanguage;

// Split locales with a region code
const languageWithoutRegionCode = language.toLowerCase().split(/[_-]+/)[0];

// Try full locale, try locale without region code, fallback to 'en'
let messages = localeData[languageWithoutRegionCode] || localeData[language];

// Default to en-US if we have no locale data
if (!messages) {
  language = 'en-US';
  messages = localeData.en;
}

svg4everybody();

ReactDOM.render(
  <IntlProvider locale={language} messages={messages}>
    <App />
  </IntlProvider>,
  document.getElementById('root')
);
